/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.designation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignation;
import technology.rocketjump.undermount.ui.GameInteractionMode;

@Singleton
public class TileDesignationDictionary {
    private Map<String, TileDesignation> byName = new HashMap<String, TileDesignation>();

    @Inject
    public TileDesignationDictionary(TextureAtlasRepository textureAtlasRepository) throws IOException {
        this(Gdx.files.internal("assets/definitions/designations.json"), textureAtlasRepository);
    }

    public TileDesignationDictionary(FileHandle designationsJson, TextureAtlasRepository textureAtlasRepository) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List allDesignations = (List)objectMapper.readValue(designationsJson.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, TileDesignation.class));
        TextureAtlas guiAtlas = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.GUI_TEXTURE_ATLAS);
        for (TileDesignation tileDesignation : allDesignations) {
            Sprite sprite = guiAtlas.createSprite(tileDesignation.getIconName());
            if (sprite == null) {
                throw new RuntimeException("No sprite found in GUI atlas by name: " + tileDesignation.getIconName());
            }
            tileDesignation.setIconSprite(sprite);
            this.byName.put(tileDesignation.getDesignationName(), tileDesignation);
        }
    }

    public TileDesignation getByName(String designationName) {
        return this.byName.get(designationName);
    }

    public void init() {
        GameInteractionMode.init(this);
    }
}

